/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.User;
import com.mckoi.database.WorkerPool;
import com.mckoi.debug.DebugLogger;

final class WorkerThread
extends Thread {
    private static final boolean DISPLAY_COMMAND_TIME = false;
    private boolean shutdown;
    private Runnable command;
    private long start_time;
    private WorkerPool worker_pool;

    public WorkerThread(WorkerPool worker_pool) {
        this.setName("Mckoi - Worker");
        this.worker_pool = worker_pool;
        this.command = null;
        this.shutdown = false;
    }

    public final DebugLogger Debug() {
        return this.worker_pool.Debug();
    }

    synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(User user, DatabaseConnection database_connection, Runnable runner) {
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            if (this.command != null) {
                throw new RuntimeException("Deadlock Error, tried to execute command on running worker.");
            }
            this.command = runner;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            try {
                block7: while (true) {
                    if (this.command != null) {
                        long l;
                        Object var2_5;
                        try {
                            this.start_time = System.currentTimeMillis();
                            this.command.run();
                            var2_5 = null;
                            this.command = null;
                        }
                        catch (Throwable throwable) {
                            var2_5 = null;
                            this.command = null;
                            l = System.currentTimeMillis() - this.start_time;
                            throw throwable;
                        }
                        l = System.currentTimeMillis() - this.start_time;
                        {
                        }
                    }
                    this.worker_pool.notifyWorkerReady(this);
                    do {
                        if (this.command != null) continue block7;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (!this.shutdown);
                    break;
                }
                return;
            }
            catch (Throwable e) {
                this.Debug().write(40, this, "Worker thread interrupted because of exception:\n" + e.getMessage());
                this.Debug().writeException(e);
                continue;
            }
            break;
        }
    }
}

